﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

using System.Xml;

// Works multiple messages. Need to improve TCP search method for multiple messages. Currently requires carrier to send + as prefix to number.

namespace CS_iSMS_Tester
{
    class iSMSnonpollingMsgParser
    {
        private iSMSmessage[] recvSMSs; // Array of iSMSmessage classes to store parsed SMS messages
        

        // Returned requested parsed message. 
        public iSMSmessage GetParsedSMS(int msgNum)
        {
            // Check if msgNum exists in Array
            if (recvSMSs[msgNum-1] != null)
                return recvSMSs[msgNum-1]; // Return SMS message stored in array at msgNum. Arrays indexing starts at zero, so minus 1.
            // msgNum SMS message wasn't found, return blank SMS message with error flagged.                       
            iSMSmessage blankSMS = new iSMSmessage();
            blankSMS.Error = true;
            return blankSMS;
        }


        // This function will determine which protocol was used to send messages, 
        // and call the appropriate parser function to return the requested message.
        public int ParseMessages(String iSMSresponse)
        {
            // Check if iSMSresponse is in the XML format
            if (iSMSresponse.Contains("<?xml"))
                return ParseHTTPMessages(iSMSresponse); // XML format, use HTTP parser.
            else
                return ParseTCPMessages(iSMSresponse); // Non XML, use TCP parser.
        }


        // The iSMS sends a XML formated message when using HTTP.
        // This function parses SMS messages from the iSMS response, 
        // stores any messages parsed in recvSMSs Array, then returns number of messages parsed.
        public int ParseHTTPMessages(String iSMSresponse)
        {
            String UE_iSMSresponse = HttpUtility.UrlDecode(iSMSresponse);
            // The HTTP request put XMLDATA= before the XML data. Remove this prefix.
            if (UE_iSMSresponse.Contains("XMLDATA="))
                UE_iSMSresponse = UE_iSMSresponse.Substring(UE_iSMSresponse.IndexOf("XMLDATA=") + "XMLDATA=".Length);
            
            // Create a XmlDocument and load the iSMS response string into it.
            XmlDocument doc = new XmlDocument();
            try
            { doc.LoadXml(UE_iSMSresponse); }
            catch(Exception e)
            {
                Console.WriteLine("Error Loading XML Doc");
                Console.WriteLine("Exception=" + e);
                Console.WriteLine("XML =" + UE_iSMSresponse);
                return 0; 
            }
                         
            // Create a list of parent nodes of the Messages. 
            // There should be an entry from each SMS message received.
            XmlNodeList MessageList = doc.GetElementsByTagName("MessageNotification");
            // MessageList.Count will display number of messages found.
            int MsgCount = MessageList.Count;
            if (MsgCount < 1) return 0; // No messages found, return 0
            // Set Array to store number of messages received.
            recvSMSs = new iSMSmessage[MsgCount];

            // Cycle through messages, and retreive message info.
            for (int i = 0; i < MsgCount; ++i)
            {
                // Create temporary iSMSmessage class to hold message info.
                iSMSmessage parsedSMS = new iSMSmessage();
                // Create a list of child nodes of the message node. The child nodes hold the message info.
                XmlNodeList MsgInfoList = MessageList[i].ChildNodes;
                parsedSMS.MessageIndex = i;
                parsedSMS.iSMS_Message = iSMSresponse;
                // Cycle through message elements and fill in message info as found
                for (int j = 0; j < MsgInfoList.Count; ++j)
                {
                    if (MsgInfoList[j].Name == "Message_Index")
                        parsedSMS.MessageIndex = Convert.ToInt32(MsgInfoList[j].InnerText.ToString());
                    if (MsgInfoList[j].Name == "ModemNumber")
                        parsedSMS.ModemInfo = MsgInfoList[j].InnerText.ToString();
                    if (MsgInfoList[j].Name == "SenderNumber")
                        parsedSMS.SenderNumber = MsgInfoList[j].InnerText.ToString();
                    if (MsgInfoList[j].Name == "Date")
                        parsedSMS.Date = MsgInfoList[j].InnerText.ToString();
                    if (MsgInfoList[j].Name == "Time")
                        parsedSMS.Time = MsgInfoList[j].InnerText.ToString();
                    if (MsgInfoList[j].Name == "EncodingFlag")
                        parsedSMS.EncodingFlag = MsgInfoList[j].InnerText.ToString();
                    if (MsgInfoList[j].Name == "Message")
                        parsedSMS.Message = MsgInfoList[j].InnerText.ToString();
                }
                // Store parsed message in Array, to be retreived later.
                //recvSMSs[i] = new iSMSmessage();
                recvSMSs[i] = parsedSMS;
            }
            // return number of messages parsed.
            return MsgCount;
        }


        // The iSMS sends non XML formated text, that has lines of text set in a specific sequence. See User Guide for more info.
        // This function parses SMS messages from the iSMS response, 
        // stores any messages parsed in recvSMSs Array, then returns number of messages parsed.
        public int ParseTCPMessages(String iSMSresponse)
        {
            // Verify that it is a message from iSMS
            if (!iSMSresponse.Contains("MultiModem iSMS"))
                return 0;

            int DataLength = 0;
            bool Authentication = false; // Number of lines are different depending if Authentication was enabled.
            bool Send_Msg_Index = false;

            // Find Authentication line.
            int NextLineStart = iSMSresponse.IndexOf("Authentication:");
            // The GetNextLine function will return the text of the line starting at NextLineStart, ending at a carraige return.
            // Get Authentication line, and detemine if Authentication was enabled.
            String NextLineText = GetNextLine(iSMSresponse, NextLineStart);
            if (NextLineText.Contains("ON"))
                Authentication = true;
            // Get Data Length    
            NextLineStart = iSMSresponse.IndexOf("Data-Length:") + "Data-Length:".Length;
            NextLineText = GetNextLine(iSMSresponse, NextLineStart);
            try
            {   DataLength = Convert.ToInt32(NextLineText, 10); }
            catch
            { } // Was an error coverting. 
                
            // Get Next to the Line (Line after Data-Length)
            NextLineText = GetNextLine(iSMSresponse, NextLineStart); 
            NextLineStart = NextLineStart + NextLineText.Length + 2; // Calculate start of next line. 
                
            // Blank line
            NextLineText = GetNextLine(iSMSresponse, NextLineStart);
            NextLineStart = NextLineStart + NextLineText.Length + 2; // Calculate start of next line. 

            if (Authentication)
            {
                // Get Username 
                NextLineText = GetNextLine(iSMSresponse, NextLineStart);
                NextLineStart = NextLineStart + NextLineText.Length + 2; // Calculate start of next line. 
                // Get Password
                NextLineText = GetNextLine(iSMSresponse, NextLineStart);
                NextLineStart = NextLineStart + NextLineText.Length + 2; // Calculate start of next line. 
            }
            else
            {
                // Extra Blank line if no authentication
                NextLineText = GetNextLine(iSMSresponse, NextLineStart);
                NextLineStart = NextLineStart + NextLineText.Length + 2; // Calculate start of next line. 
            }

            // Check if Msg_Count and Msg_Index are included
            NextLineText = GetNextLine(iSMSresponse, NextLineStart);
            if (NextLineText.StartsWith("Msg_Count: "))
            {
                Send_Msg_Index = true;
                //NextLineStart = NextLineStart + 11; // "Msg_Count: "
                NextLineStart = NextLineStart + NextLineText.Length + 2; // Calculate start of next line. 
            }

            // The non-polling mode currently sends up to two messages. Set array to handle atleast 2 messages.
            recvSMSs = new iSMSmessage[52];
            // NextLineStart is currently at beginning of first message.
            //int startMsg = NextLineStart;
            int MsgCount = 0; // Tracks how many messages are found
            bool lastMsg = false;
            do
            {
                MsgCount++;
                // Create temporary iSMSmessage class to store message being parsed.
                iSMSmessage parsedSMS = new iSMSmessage();

                parsedSMS.iSMS_Message = iSMSresponse;

                if (Send_Msg_Index)
                {
                    // Get Modem Info
                    NextLineText = GetNextLine(iSMSresponse, NextLineStart);
                    if (NextLineText.Length>=10)
                        parsedSMS.MessageIndex = Convert.ToInt32(NextLineText.Substring(10)); //Msg_Index_
                    NextLineStart = NextLineStart + NextLineText.Length + 2; // Calculate start of next line. 
                }
                else
                    parsedSMS.MessageIndex = MsgCount;

                // Get Modem Info
                NextLineText = GetNextLine(iSMSresponse, NextLineStart);
                parsedSMS.ModemInfo = NextLineText;
                NextLineStart = NextLineStart + NextLineText.Length + 2; // Calculate start of next line. 
                // Get SenderNumber
                NextLineText = GetNextLine(iSMSresponse, NextLineStart);
                parsedSMS.SenderNumber = NextLineText;
                NextLineStart = NextLineStart + NextLineText.Length + 2; // Calculate start of next line. 
                // Get Date
                NextLineText = GetNextLine(iSMSresponse, NextLineStart);
                parsedSMS.Date = NextLineText;
                NextLineStart = NextLineStart + NextLineText.Length + 2;
                // Get Time
                NextLineText = GetNextLine(iSMSresponse, NextLineStart);
                parsedSMS.Time = NextLineText;
                NextLineStart = NextLineStart + NextLineText.Length + 2;
                // Check for Encoding info.
                NextLineText = GetNextLine(iSMSresponse, NextLineStart);
                if (NextLineText.StartsWith("ASCII") || NextLineText.StartsWith("Extended ASCII") || NextLineText.StartsWith("Unicode"))
                {
                    parsedSMS.EncodingFlag = NextLineText;
                    NextLineStart = NextLineStart + NextLineText.Length + 2;
                }
                if (NextLineStart < iSMSresponse.Length - 1)
                    NextLineText = iSMSresponse.Substring(NextLineStart);
                else
                    NextLineText = " ";
                if (Send_Msg_Index)
                {
                    if (NextLineText.Contains("Msg_Index_"))
                    {
                        int MsgLen = NextLineText.IndexOf("Msg_Index_");
                        parsedSMS.Message = NextLineText.Substring(0, MsgLen-2);
                        NextLineStart += MsgLen;
                    }
                    else
                    {
                        if (NextLineText.Length > 2)
                            NextLineText = NextLineText.Substring(0, NextLineText.Length - 2);
                        parsedSMS.Message = NextLineText;
                        lastMsg = true;
                    }
                }
                else
                {   // Nearly impossible to search for multiple messages without Msg_Index_
                    if (NextLineText.Length > 2)
                        NextLineText = NextLineText.Substring(0, NextLineText.Length - 2);
                    parsedSMS.Message = NextLineText;
                    lastMsg = true;
                }


                // Store parsed message in Array to be retreived later.
                //recvSMSs[MsgCount] = new iSMSmessage();
                recvSMSs[MsgCount-1] = parsedSMS;
            }
            while (lastMsg == false);
            
            return MsgCount; // return number of messages parsed.
        }


        // The GetNextLine function will return the text of the line starting at NextLineStart.
        // Each line ends with a carraige return and line feed. It searches for Carraige return to determine end of the line.
        private String GetNextLine(String Message, int NextLineStart)
        {
            if (NextLineStart > Message.Length-1) return "";
            try
            {
                int NextLineEnd = Message.IndexOfAny("\r".ToCharArray(), NextLineStart); // Find end of line (carraige return).
                String NextLineText = Message.Substring(NextLineStart, NextLineEnd - NextLineStart); // Use substring to get text from start of line to end.
                return NextLineText; // return line text.
            }
            catch (Exception)
            {
                return ""; // If error, return a blank line.
            }
        }
    }
}
